<?php
session_start();
require __DIR__ . '/../shared/db.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
  header("Location: ../login.php");
  exit;
}
$accounts = $pdo->query("SELECT a.*, u.username as owner, s.name as server_name, s.ip_address, s.api_port, s.api_user, s.api_pass
  FROM vpn_accounts a
  JOIN web_users u ON a.user_id = u.id
  JOIN vpn_servers s ON a.server_id = s.id ORDER BY a.id DESC")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'];
  $vpn_username = $_POST['vpn_username'];
  $server_id = $_POST['server_id'];

  $server = $pdo->prepare("SELECT * FROM vpn_servers WHERE id = ?");
  $server->execute([$server_id]);
  $srv = $server->fetch();

  $url = "http://{$srv['ip_address']}:{$srv['api_port']}/$action";
  $auth = base64_encode("{$srv['api_user']}:" . base64_decode($srv['api_pass']));
  $data = ['username' => $vpn_username];

  $opts = ['http' => [
    'method' => 'POST',
    'header' => ["Authorization: Basic $auth", "Content-Type: application/json"],
    'content' => json_encode($data)
  ]];
  file_get_contents($url, false, stream_context_create($opts));

  if ($action === 'delete-user') {
    $pdo->prepare("DELETE FROM vpn_accounts WHERE username = ? AND server_id = ?")->execute([$vpn_username, $server_id]);
  }

  header("Location: admin_dashboard_vpn.php");
  exit;
}
?>
<!DOCTYPE html><html><head><title>Kelola VPN - Admin</title><link rel="stylesheet" href="../shared/assets/style.css"></head><body>
<div class="container">
<h2>Panel Admin: Semua Akun VPN</h2>
<p><a href="index.php">← Dashboard</a> | <a href="../logout.php">Logout</a></p>

<table><tr><th>Username VPN</th><th>Owner</th><th>Server</th><th>IP</th><th>Expired</th><th>Aksi</th></tr>
<?php foreach ($accounts as $a): ?>
<tr>
  <td><?= $a['username'] ?></td>
  <td><?= $a['owner'] ?></td>
  <td><?= $a['server_name'] ?></td>
  <td><?= $a['vpn_ip'] ?></td>
  <td><?= $a['expired_at'] ?></td>
  <td>
    <form method="POST" style="display:inline;">
      <input type="hidden" name="vpn_username" value="<?= $a['username'] ?>">
      <input type="hidden" name="server_id" value="<?= $a['server_id'] ?>">
      <button name="action" value="delete-user" onclick="return confirm('Yakin hapus akun ini?')">🗑 Delete</button>
      <button name="action" value="disable-user">⛔ Disable</button>
      <button name="action" value="enable-user">✅ Enable</button>
    </form>
  </td>
</tr>
<?php endforeach; ?>
</table>
</div>
</body></html>
