<?php
session_start(); require __DIR__ . '/../shared/db.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') header('Location: login.php');

$now = date('Y-m-d');
$future = date('Y-m-d', strtotime('+7 days'));
$stmt = $pdo->query("SELECT a.*, s.name as server_name, u.username as owner_name
  FROM vpn_accounts a
  JOIN vpn_servers s ON a.server_id = s.id
  JOIN web_users u ON a.user_id = u.id
  WHERE a.expired_at IS NOT NULL
  ORDER BY a.expired_at ASC");
$accounts = $stmt->fetchAll();
?><!DOCTYPE html><html><head><title>Akun VPN Expiring</title>
<link rel="stylesheet" href="assets/style.css"></head><body><div class="container">
<h2>Daftar Akun VPN Expiring / Expired</h2>
<a href="index.php">← Kembali ke Dashboard</a>
<table><tr><th>Username</th><th>IP</th><th>Owner</th><th>Server</th><th>Expired At</th><th>Status</th></tr>
<?php foreach($accounts as $a): 
  $status = (strtotime($a['expired_at']) < time()) ? '❌ Expired' : ((strtotime($a['expired_at']) <= strtotime($future)) ? '⚠️ Akan Expired' : '✅ Aktif');
?><tr>
<td><?= $a['username'] ?></td>
<td><?= $a['vpn_ip'] ?></td>
<td><?= $a['owner_name'] ?></td>
<td><?= $a['server_name'] ?></td>
<td><?= $a['expired_at'] ?></td>
<td><?= $status ?></td>
</tr><?php endforeach; ?>
</table></div></body></html>