<?php
session_start();
require __DIR__ . '/../shared/db.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
  header("Location: ../login.php");
  exit;
}

// filter logic
$filter_server = $_GET['server'] ?? '';
$search = $_GET['search'] ?? '';

$where = "WHERE 1=1";
$params = [];

if ($filter_server !== '') {
  $where .= " AND a.server_id = ?";
  $params[] = $filter_server;
}
if ($search !== '') {
  $where .= " AND a.username LIKE ?";
  $params[] = "%$search%";
}

$servers = $pdo->query("SELECT * FROM vpn_servers")->fetchAll();
$sql = "SELECT a.*, u.username as owner, s.name as server_name
        FROM vpn_accounts a
        JOIN web_users u ON a.user_id = u.id
        JOIN vpn_servers s ON a.server_id = s.id
        $where ORDER BY a.expired_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$accounts = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = $_POST['action'];
  $username = $_POST['vpn_username'];
  $server = $pdo->prepare("SELECT * FROM vpn_servers WHERE id = ?");
  $server->execute([$_POST['server_id']]);
  $srv = $server->fetch();
  $url = "http://{$srv['ip_address']}:{$srv['api_port']}/{$action}";
  $auth = base64_encode("{$srv['api_user']}:" . base64_decode($srv['api_pass']));
  $data = ['username' => $username];
  if ($action === 'add-user') $data['password'] = $_POST['vpn_password'];
  $opts = ['http' => [
    'method' => 'POST',
    'header' => [
      "Authorization: Basic $auth",
      "Content-Type: application/json"
    ],
    'content' => json_encode($data)
  ]];
  $ctx = stream_context_create($opts);
  $res = file_get_contents($url, false, $ctx);
  $msg = $res ? "Action berhasil." : "Gagal hubungi FastAPI.";
  header("Location: admin_vpn_accounts.php?msg=" . urlencode($msg));
  exit;
}
?>
<!DOCTYPE html>
<html><head><title>Kelola VPN</title><link rel="stylesheet" href="../shared/assets/style.css"></head><body>
<div class="container">
<h2>Admin: Kelola Semua Akun VPN</h2>
<?php if (isset($_GET['msg'])) echo "<p style='color:green'>{$_GET['msg']}</p>"; ?>

<form method="POST">
  <select name="server_id" required>
    <option value="">Pilih Server</option>
    <?php foreach ($servers as $s): ?>
    <option value="<?= $s['id'] ?>"><?= $s['name'] ?> - <?= $s['ip_address'] ?></option>
    <?php endforeach; ?>
  </select>
  <input type="text" name="vpn_username" placeholder="Username VPN" required>
  <input type="text" name="vpn_password" placeholder="Password VPN (untuk add-user)">
  <select name="action" required>
    <option value="add-user">➕ Buat Akun</option>
    <option value="delete-user">🗑 Hapus Akun</option>
    <option value="disable-user">⛔ Nonaktifkan</option>
    <option value="enable-user">✅ Aktifkan</option>
  </select>
  <button type="submit">Kirim</button>
</form>

<hr>
<form method="GET" class="mt-4">
  <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" placeholder="Cari username">
  <select name="server">
    <option value="">Semua Server</option>
    <?php foreach ($servers as $s): ?>
    <option value="<?= $s['id'] ?>" <?= $filter_server == $s['id'] ? 'selected' : '' ?>>
      <?= $s['name'] ?> - <?= $s['ip_address'] ?>
    </option>
    <?php endforeach; ?>
  </select>
  <button type="submit">Filter</button>
</form>

<h3>Daftar Akun VPN</h3>
<table><tr><th>Username</th><th>IP</th><th>Owner</th><th>Server</th><th>Expired</th></tr>
<?php foreach ($accounts as $a): ?>
<tr>
  <td><?= $a['username'] ?></td>
  <td><?= $a['vpn_ip'] ?></td>
  <td><?= $a['owner'] ?></td>
  <td><?= $a['server_name'] ?></td>
  <td><?= $a['expired_at'] ?></td>
</tr>
<?php endforeach; ?>
</table>
<p><a href="index.php">← Kembali</a></p>
</div>
</body></html>
