<?php
session_start();
require __DIR__ . '/../shared/db.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
  header("Location: login.php");
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = $_POST['name'];
  $ip = $_POST['ip_address'];
  $port = $_POST['api_port'];
  $user = $_POST['api_user'];
  $pass = $_POST['api_pass'];
  $enc = base64_encode($pass);
  $pdo->prepare("INSERT INTO vpn_servers (name, ip_address, api_port, api_user, api_pass) VALUES (?, ?, ?, ?, ?)")
      ->execute([$name, $ip, $port, $user, $enc]);
  header("Location: servers.php");
  exit;
}

if (isset($_GET['delete'])) {
  $pdo->prepare("DELETE FROM vpn_servers WHERE id = ?")->execute([$_GET['delete']]);
  header("Location: servers.php");
  exit;
}

$servers = $pdo->query("SELECT * FROM vpn_servers ORDER BY id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html>
<head><title>Server Management</title><link rel="stylesheet" href="assets/style.css"></head>
<body>
<div class="container">
<h2>Kelola Server VPN</h2>
<form method="POST">
  <input type="text" name="name" placeholder="Nama Server" required>
  <input type="text" name="ip_address" placeholder="IP Server" required>
  <input type="number" name="api_port" placeholder="Port API (contoh: 9000)" required>
  <input type="text" name="api_user" placeholder="Username API" required>
  <input type="text" name="api_pass" placeholder="Password API" required>
  <button type="submit">Tambah Server</button>
</form>

<h3>Daftar Server</h3>
<table>
<tr><th>Nama</th><th>IP</th><th>Port</th><th>User</th><th>Aksi</th></tr>
<?php foreach ($servers as $s): ?>
<tr>
  <td><?= htmlspecialchars($s['name']) ?></td>
  <td><?= $s['ip_address'] ?></td>
  <td><?= $s['api_port'] ?></td>
  <td><?= $s['api_user'] ?></td>
  <td><a href="?delete=<?= $s['id'] ?>" onclick="return confirm('Hapus server ini?')">🗑 Hapus</a></td>
</tr>
<?php endforeach; ?>
</table>
</div>
</body>
</html>
